<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:javaFile="javaFile:java.io.File" exclude-result-prefixes="javaFile">
	<xsl:script language="java" implements-prefix="javaFile" src="java:java.io.File"/>
	<!-- This file (propertylinks.xsl) contains the linking logic for properties -->
	<!-- ################### Template propertylinks ###################### -->
	<!-- This template builds links for properties that are inherited, but that
     are not listed in the members list  -->
	<xsl:template name="propertylinks">
		<xsl:variable name="class" select="@name"/>
		<xsl:variable name="context" select="."/>
		<xsl:for-each select=".//propertyref">
			<xsl:variable name="proprefname" select="@name"/>
			<!-- Make sure it's not published locally -->
			<xsl:choose>
				<xsl:when test="count($context//property[@name=$proprefname and @hasdoc='yes'])=0">
					<!-- check for nested classes -->
					<!-- parent is <ancestor>, parent of which is <class> or <interface>, parent of which should be namespace... unless it's in a nested class/interface!-->
					<xsl:choose>
						<xsl:when test="ancestor::class/../../class or ancestor::class/../../interface or ancestor::interface/../../class or ancestor::interface/../../interface">
							<!-- don't include propertyrefs in nested classes for now -->
							<!--						<xsl:message>
							<xsl:text>!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!PROPERTYREF IN NESTED CLASS/INTERFACE: propertyref </xsl:text>
							<xsl:value-of select="$proprefname"/>
							<xsl:text> in </xsl:text>
							<xsl:value-of select="$class"/>
							<xsl:text> in </xsl:text>
							<xsl:value-of select="../../@name"/>
							<xsl:text>!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!</xsl:text>
						</xsl:message>-->
						</xsl:when>
						<xsl:otherwise>
							<!-- look for links only for the top propref with this name in this class
						 if it's not documented, other links will be found in recurseancestor -->
							<xsl:choose>
								<xsl:when test="not(ancestor::*[preceding-sibling::propertyref[@name=$proprefname]])">
									<!--                                                  <xsl:message>
                                                    Attempting recursion.
                                                  </xsl:message>
-->
									<xsl:call-template name="recurseancestorproperties">
										<xsl:with-param name="prop" select="@name"/>
										<xsl:with-param name="class" select="../@name"/>
										<xsl:with-param name="unit" select="../@namespace"/>
									</xsl:call-template>
								</xsl:when>
								<xsl:otherwise>
									<!--                                                  <xsl:message>
                                                    another node: <xsl:copy-of select="ancestor::*[preceding-sibling::propertyref[@name=$proprefname]]"/>
                                                  </xsl:message>
-->
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<!--                          <xsl:message>
                            Count: <xsl:copy-of select="$context/members/property[@name=$proprefname and @hasdoc='yes']"/>
                          </xsl:message>-->
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
		
		<!-- #### links to members of implemented interfaces #### -->
		<xsl:for-each select=".//property[boolean(@declaring_interface)]">
			<xsl:variable name="intpropname">
				<xsl:value-of select="@name"/>
			</xsl:variable>
			<!-- check for nested classes -->
			<!-- look for class/class in the ancestry
                 or class/interface or interface/class or
                 interface/interface ... -->
			<xsl:choose>
				<xsl:when test="ancestor::class/../../class or ancestor::class/../../interface or ancestor::interface/../../class or ancestor::interface/../../interface">
					<!--
                <xsl:message>
                    <xsl:text>!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!METHODREF IN NESTED INTERFACE: methodref </xsl:text><xsl:value-of select="$intprocname"/><xsl:text> in </xsl:text><xsl:value-of select = "$class"/><xsl:text> in </xsl:text><xsl:value-of select="../../@name"/><xsl:text>!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!</xsl:text>
                </xsl:message>
-->
				</xsl:when>
				<xsl:otherwise>
					<xsl:variable name="declaring_interface">
						<xsl:value-of select="@declaring_interface"/>
					</xsl:variable>
					<xsl:variable name="linktarget">
						<xsl:value-of select="//class[@name=$class]/interfaces/implements[contains(@name, $declaring_interface)]/@name"/>
					</xsl:variable>
					<propertylink>
						<xsl:attribute name="declaring_interface"><xsl:value-of select="$declaring_interface"/></xsl:attribute>
						<!-- 07/03/03 SN changed these two tests from $declaring_interface to $linktarget; $declaring_interface doesn't have the full path information (including 'Borland.' -->
						<xsl:if test="not(contains($linktarget, 'Borland'))">
							<xsl:attribute name="docset"><xsl:value-of select="'microsoft'"/></xsl:attribute>
						</xsl:if>
						<xsl:if test="contains($linktarget, 'Borland')">
							<xsl:attribute name="docset"><xsl:value-of select="'borland'"/></xsl:attribute>
						</xsl:if>
						<namespace>
							<xsl:value-of select="substring-before($linktarget, concat('.', $declaring_interface))"/>
						</namespace>
						<interface>
							<xsl:value-of select="$declaring_interface"/>
						</interface>
						<property>
							<xsl:value-of select="$intpropname"/>
						</property>
					</propertylink>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
		
	</xsl:template>

	<!-- ###################### recurseancestor ##############################3 -->
	<!-- This template is a recursive template. It opens the file that the first property of the same name
     in the ancestor list references. If the property is documented in this class, it writes link
     information. If not, it calls itself, with parameters for the *next* ancestor in the ancestor list
     that has a property of the same name.
     -->
	<!-- not worrying about nested classes here, in the ancestor hierarchy... -->
	<xsl:template name="recurseancestorproperties">
		<xsl:param name="prop"/>
		<xsl:param name="class"/>
		<xsl:param name="unit"/>
		<!--                <xsl:message>
                  Recursing: <xsl:value-of select="concat($unit,'.',$class,'.',$prop)"/>
                </xsl:message>-->
		<xsl:variable name="classfile" select="concat('compileroutput', '/', $unit, '.xml')"/>
		<!--This next for-each performs operations on each property that we are looking for.-->
		<xsl:variable name="filename" select="javaFile:new($classfile)"/>
		<xsl:choose>
			<xsl:when test="javaFile:exists($filename)">
				<xsl:for-each select="document($classfile)/namespace/class[@name=$class]//property[@name=$prop]">
					<!-- new criterion: hasdoc = "yes" means it is documented here -->
					<xsl:choose>
						<xsl:when test="@hasdoc='yes'">
							<propertylink>
								<xsl:variable name="linknamespace">
									<xsl:value-of select="/namespace/@name"/>
								</xsl:variable>
								<xsl:if test="contains($linknamespace, 'Borland')">
									<xsl:attribute name="docset">borland</xsl:attribute>
								</xsl:if>
								<xsl:if test="not(contains($linknamespace, 'Borland'))">
									<xsl:attribute name="docset">microsoft</xsl:attribute>
								</xsl:if>
								<namespace>
									<xsl:value-of select="$unit"/>
								</namespace>
								<class>
									<xsl:value-of select="$class"/>
								</class>
								<property>
									<xsl:value-of select="$prop"/>
								</property>
							</propertylink>
						</xsl:when>
						<!-- if it's not one of our namespaces, don't look for doc, just link -->
						<xsl:when test="not(contains($unit,'Borland'))">
							<propertylink>
								<xsl:variable name="linknamespace">
									<xsl:value-of select="/namespace/@name"/>
								</xsl:variable>
								<xsl:if test="contains($linknamespace, 'Borland')">
									<xsl:attribute name="docset">borland</xsl:attribute>
								</xsl:if>
								<xsl:if test="not(contains($linknamespace, 'Borland'))">
									<xsl:attribute name="docset">microsoft</xsl:attribute>
								</xsl:if>
								<namespace>
									<xsl:value-of select="$unit"/>
								</namespace>
								<class>
									<xsl:value-of select="$class"/>
								</class>
								<property>
									<xsl:value-of select="$prop"/>
								</property>
							</propertylink>
						</xsl:when>
						<!-- otherwise don't link it, look at ancestors -->
						<xsl:otherwise>
							<xsl:for-each select="/namespace/class[@name=$class]">
								<!--This for-each selects the first ancestor in the ancestor list that has a
                     property of the same name-->
								<xsl:for-each select="(.//ancestor/propertyref[@name=$prop])[1]">
									<!--Here we call the recursive template with parameters for property, class and unit -->
									<xsl:call-template name="recurseancestorproperties">
										<xsl:with-param name="prop" select="$prop"/>
										<xsl:with-param name="class" select="../@name"/>
										<xsl:with-param name="unit" select="../@namespace"/>
									</xsl:call-template>
								</xsl:for-each>
							</xsl:for-each>
						</xsl:otherwise>
					</xsl:choose>
					<!--
            <xsl:if test = "not (javaFile:exists($filename))">
              <xsl:message>Unable to open <xsl:value-of select = "$ancestorfile"/> to find property links.</xsl:message>

          </xsl:if>
-->
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<!-- if file doesn't exist, set up link anyway -->
				<propertylink>
					<xsl:variable name="linknamespace">
						<xsl:value-of select="$unit"/>
					</xsl:variable>
					<xsl:if test="contains($linknamespace, 'Borland')">
						<xsl:attribute name="docset">borland</xsl:attribute>
					</xsl:if>
					<xsl:if test="not(contains($linknamespace, 'Borland'))">
						<xsl:attribute name="docset">microsoft</xsl:attribute>
					</xsl:if>
					<namespace>
						<xsl:value-of select="$unit"/>
					</namespace>
					<class>
						<xsl:value-of select="$class"/>
					</class>
					<property>
						<xsl:value-of select="$prop"/>
					</property>
				</propertylink>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
